#include <bits/stdc++.h>

using namespace std;
using ll = long long;
using ld = long double;

struct p {
    ld x, y;
    p operator-(p a) const {
        return {this->x - a.x, this->y - a.y};
    }
    p operator+(p a) const {
        return {this->x + a.x, this->y + a.y};
    }
    ld operator%(p a) const {
        return this->x * a.y - a.x * this->y;
    }
    p operator*(ld k) const {
        return {this->x * k, this->y * k};
    }
};

bool check_intersect(pair<p, p> a, pair<p, p> b) {
    return ((a.first - b.first) % (a.second - b.first)) * ((a.first - b.second) % (a.second - b.second)) <= 0 && ((b.first - a.first) % (b.second - a.first)) * ((b.first - a.second) % (b.second - a.second)) <= 0;
}

int get(int a, vector<int>& p) {
    if (p[a] == a) {
        return a;
    }
    return p[a] = get(p[a], p);
}

void unite(int a, int b, vector<int>& p, vector<int>& w) {
    int p1 = get(a, p);
    int p2 = get(b, p);
    if (w[p1] < w[p2]) {
        p[p1] = p2;
        w[p2] += w[p1];
    } else {
        p[p2] = p1;
        w[p1] += w[p2];
    }
}

ld get_int_x(pair<p, p> a, pair<p, p> b) {
    p napr = a.second - a.first;
    ld l = 0, r = 1;
    for (int i = 0; i < 100; ++i) {
        ld m = (l + r) / 2;
        if (check_intersect({a.first, a.first + napr * m}, b)) {
            r = m;
        } else {
            l = m;
        }
    }
    return a.first.x + napr.x * r;
}

ld get_int_y(pair<p, p> a, pair<p, p> b) {
    p napr = a.second - a.first;
    ld l = 0, r = 1;
    for (int i = 0; i < 100; ++i) {
        ld m = (l + r) / 2;
        if (check_intersect({a.first, a.first + napr * m}, b)) {
            r = m;
        } else {
            l = m;
        }
    }
    return a.first.y + napr.y * r;
}


void solve() {
    int n;
    cin >> n;
    vector<pair<p, p>> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i].first.x >> a[i].first.y >> a[i].second.x >> a[i].second.y;
    }
    vector<int> p(n);
    vector<int> w(n, 1);
    for (int i = 0; i < n; ++i) {
        p[i] = i;
    }
    ll cnt = 1;
    for (int i = 1; i < n; ++i) {
        vector<pair<ld, int>> ints;
        for (int j = 0; j < i; ++j) {
            if (check_intersect(a[i], a[j])) {
                if (a[i].first.x != a[i].second.x) {
                    ints.emplace_back(get_int_x(a[i], a[j]), j);
                } else {
                    ints.emplace_back(get_int_y(a[i], a[j]), j);
                }
            }
        }
        sort(ints.begin(), ints.end());
        for (int j = 0; j + 1 < ints.size(); ++j) {
            if (get(ints[j].second, p) == get(ints[j + 1].second, p)) {
                ++cnt;
            }
        }
        for (int j = 0; j < ints.size(); ++j) {
            unite(i, ints[j].second, p, w);
        }
    }
    cout << cnt << '\n';
}

int main() {
    ll t;
    cin >> t;
    while(t--) {
        solve();
    }
    return 0;
}
